/*
 * ContagionModels.cpp
 *
 *  Created on: Nov 27, 2013
 *      Author: nino
 */

#include <ContagionModels.h>

void run_contagion_model(infected_structure * p_infected_parameters, SIMULATION_TYPE sim_type, igraph_vector_t * infected_nodes_history , contagion_param_struct * epidemicParameters_exp, unsigned seed){

	//do not know sim num
	run_contagion_model(p_infected_parameters, sim_type, infected_nodes_history, epidemicParameters_exp, seed, 0);
}

void run_contagion_model(infected_structure * p_infected_parameters, SIMULATION_TYPE sim_type, igraph_vector_t * infected_nodes_history , contagion_param_struct * epidemicParameters_exp, unsigned seed, int sim_num){

	//clear statistics ubaceno u contagion modele
	int T_rnd_value; double p_rnd_value, q_rnd_value;
	if( epidemicParameters_exp->randomize_parameters == 1) { // if noise_sample are empty then parameters are also constats
		if ( (epidemicParameters_exp->estimate_T_from_temporal_contacts == 1) && (sim_type == LAZY_RECOVERY_SIR_TEMPORAL_NET_FROM_TO)){
			epidemicParameters_exp->T_start = get_random_sample( &(epidemicParameters_exp->T_activity_times) );
			if (epidemicParameters_exp->T_start > epidemicParameters_exp->T_end){
				printf("ERROR : T_start %d in function: run_contagion_model() > T_end %d \n", epidemicParameters_exp->T_start, epidemicParameters_exp->T_end); exit(-1);
			}
		}else{
			T_rnd_value = get_T_rnd_sample( &epidemicParameters_exp->T_distr_sample_noise, epidemicParameters_exp->T );
		}
		p_rnd_value = get_rnd_pq_value( &epidemicParameters_exp->norm_distr_sample_noise, epidemicParameters_exp->p );
		q_rnd_value = get_rnd_pq_value( &epidemicParameters_exp->norm_distr_sample_noise, epidemicParameters_exp->q );
	}else{
		T_rnd_value = epidemicParameters_exp->T;
		p_rnd_value = epidemicParameters_exp->p;
		q_rnd_value = epidemicParameters_exp->q;
	}

	if (sim_type == NAIVE_SIR_UNWEIGHTED_NET){
		igraph_epidemic_classic_temporal(p_infected_parameters, p_rnd_value, q_rnd_value, infected_nodes_history, T_rnd_value);
	}else if( (sim_type == NAIVE_SIR_WEIGHTED_NET) && (p_infected_parameters->use_weighted_static_network == 1) ){
		igraph_epidemic_weighted_temporal(p_infected_parameters , p_rnd_value, q_rnd_value, infected_nodes_history, T_rnd_value);
	}else if( (sim_type == LAZY_RECOVERY_SIR_TEMPORAL_NET) && (p_infected_parameters->use_temporal_network_structure == 1) ){
		igraph_SIR_temporal_contact_network( p_infected_parameters, p_rnd_value, q_rnd_value, infected_nodes_history, T_rnd_value, seed);
	}else if( (sim_type == LAZY_RECOVERY_SIR_TEMPORAL_NET_FROM_TO) && (p_infected_parameters->use_temporal_network_structure == 1) ){
		igraph_SIR_temporal_contact_network(p_infected_parameters, p_rnd_value, q_rnd_value, infected_nodes_history, epidemicParameters_exp->T_start, epidemicParameters_exp->T_end, seed, sim_num);
	}else{
		printf("Wrong contagion process !!!\n");
		exit(-1);
	}
}

/**
 * Function that simulate one epidemic spread unitl temporal Threshold T: T_value
 * @param p_infected_parameters struct of infected parameters
 * @param recovered_nodes infected and recovered nodes in simulation
 * @param p
 * @param q
 * @return
 */
void igraph_epidemic_classic_temporal(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value) {

	igraph_vector_null(infected_nodes);
	igraph_dqueue_clear(p_infected_parameters->dq_infected_nodes);

    igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, p_infected_parameters->start_node);
    VECTOR(*infected_nodes)[p_infected_parameters->start_node] = 1;
	int dis_time = 1;
	int delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
	//printf("\n ------------------------discrete time step : %d -----------------", dis_time);

    while (igraph_dqueue_size(p_infected_parameters->dq_infected_nodes)) {
		if ( delta_nodes_pop == 0 ){
			dis_time++; // discrete epidemic time
			delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
			//printf("\n ------------------------discrete time step : %d -----------------", dis_time);
		}

		if ( dis_time <= T_value){
			long int current_node;
			current_node = (long int) igraph_dqueue_pop(p_infected_parameters->dq_infected_nodes);
			delta_nodes_pop--;
			//printf(" \n Current node: %d ", current_node);

			igraph_vector_t *neis;
			neis = igraph_adjlist_get(p_infected_parameters->al, current_node);
			igraph_real_t no_of_neigh;
			no_of_neigh = igraph_vector_size(neis);

			long int current_neigh;

			for (int i = 0; i < no_of_neigh; ++i) {
				current_neigh = (long int) VECTOR(*neis)[i];

				// provjera da li je trenutni cvor vec podlozan
				if (VECTOR(*infected_nodes)[current_neigh] == 0) {
					if (my_random() <= p) {
						igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, (igraph_real_t) current_neigh);
						VECTOR(*infected_nodes)[current_neigh] = 1;
						//printf(" \n Infected node: %d ", current_neigh);
					}
				}
			}

			if (my_random() > q) {
				igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, current_node);
			}
			// igraph_vector_destroy(neis);
		}else{
			break;
		}
    }
}

void igraph_SIR_temporal_contact_network(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes_history, int T_value, unsigned seed){
// This function takes list of contacts between corresponding nodes (contact_array_1[i] and contact_array_2[i]) at time step: time_contact_array[i] and simulates
// SIR epidemics on these temporal network with T_value steps, contacts within window of size T_win_size are aggregated
// IMPORTANT: contact_arrays need to be sorted w.r.t. time_contact_array in time order !!!
// UNDER_WORK

	igraph_vector_null(infected_nodes_history);
	igraph_dqueue_clear(p_infected_parameters->dq_infected_nodes);
	//int T_start = p_infected_parameters->time_contact_array->at(1); // WHY 1 ????
	int T_start = p_infected_parameters->time_contact_array->at(0);
	int T_end = T_start + T_value; // number of simulated steps

	if (p_infected_parameters->randomize_temporal_contacts == 1){ // if temporal delta randomization is active O(contact_size_list)
		//unsigned seed = std::chrono::system_clock::now().time_since_epoch().count() * getpid();
		if (p_infected_parameters->randomize_null_model_uniformly == 0){ // permuation null model
			randomize_temporal_contacts(p_infected_parameters, T_end , seed);
		}else{ // uniform null model
			randomize_temporal_contacts_uniformly(p_infected_parameters, T_end , seed);
		}
	}

	VECTOR(*infected_nodes_history)[p_infected_parameters->start_node] = 1; // here we status 1 for each node that got infected at any time

	vector<int> susceptible_state_in_time(p_infected_parameters->no_of_nodes,1); //here we write the whether node is susceptible in tmp_T step
	susceptible_state_in_time[p_infected_parameters->start_node] = 0;

	vector<int> infective_state_in_time(p_infected_parameters->no_of_nodes, 0); //here we write the whether node is infective in tmp_T step
	infective_state_in_time[p_infected_parameters->start_node] = 1;

	vector<int> node_recovery_probe_time(p_infected_parameters->no_of_nodes, 0); // hold info about last recovery probe time for lazy evaluation for recovery
	//node_recovery_probe_time[p_infected_parameters->start_node] = p_infected_parameters->time_contact_array->at(1); //!!! WHY 1
	node_recovery_probe_time[p_infected_parameters->start_node] = p_infected_parameters->time_contact_array->at(0);



	int T_last = T_start; // for verification of sorted list

	for(int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){ //sweep over contacts or interactions not in time

		int tmp_T = p_infected_parameters->time_contact_array->at(i); // current time of contact
		if (T_last <= tmp_T){ // verification of time order

			if (tmp_T < T_end){ // proceed, simulation is not finished

				int contact_1 = p_infected_parameters->contact_array_1->at(i);
				int contact_2 = p_infected_parameters->contact_array_2->at(i);

				if ( infective_state_in_time[contact_1] ){ // recovery_step - lazy evaluation for contact 1
					int delta_t = tmp_T - node_recovery_probe_time.at(contact_1); // number of time steps that we did not probe contact_1 for recovery
					double q_tmp = 1 - ( pow((1-q),delta_t) ); // probability that nodes recovers after delta_t steps
					if (my_random() <= q_tmp){
						infective_state_in_time[contact_1] = 0;
					}
					node_recovery_probe_time.at(contact_1) = tmp_T; // we write time of last recovery probing for contact_1
				}

				if ( infective_state_in_time[contact_2] ){ // recovery_step - lazy evaluation for contact 2
					int delta_t = tmp_T - node_recovery_probe_time.at(contact_2);
					double q_tmp = 1 - ( pow((1-q),delta_t) ) ; // probability that nodes recovers after delta_t steps
					if (my_random() <= q_tmp){
						infective_state_in_time[contact_2] = 0;
					}
					node_recovery_probe_time.at(contact_2) = tmp_T;
				}

				if  ( infective_state_in_time[contact_1] && susceptible_state_in_time[contact_2] && (my_random() <= p)) { // infective step: contact_1 -> contact 2
					VECTOR(*infected_nodes_history)[contact_2] = 1; // second node becomes infected
					susceptible_state_in_time[contact_2] = 0;
					infective_state_in_time[contact_2] = 1;
					node_recovery_probe_time.at(contact_2) = tmp_T+1; // Recovery probing should be done only after this nodes tries to infect others
				}else if ( infective_state_in_time[contact_2] && susceptible_state_in_time[contact_1] && (my_random() <= p)){ // infective step: contact_1 <- contact 2
					VECTOR(*infected_nodes_history)[contact_1] = 1; // first node becomes infected
					susceptible_state_in_time[contact_1] = 0;
					infective_state_in_time[contact_1] = 1;
					node_recovery_probe_time.at(contact_1) = tmp_T+1;
				}

			}else{ // we have reached the end of simulation period
				break;
			}
			T_last = tmp_T;

		}else{ // contacts are not sorted in time !!!
			printf("\n ***!!! ERROR: Contacts are not sorted in time [time last: %d,time now %d] step:%d !!!*** \n", T_last, tmp_T,i);
			break;
		}

	}

	susceptible_state_in_time.clear();
	infective_state_in_time.clear();
	node_recovery_probe_time.clear();
}

void igraph_SIR_temporal_contact_network(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes_history, int T_start, int T_end, unsigned seed){

	igraph_SIR_temporal_contact_network(p_infected_parameters, p, q, infected_nodes_history, T_start, T_end, seed, 0);

}

void igraph_SIR_temporal_contact_network(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes_history, int T_start, int T_end, unsigned seed, int sim_num){
// This function takes list of contacts between corresponding nodes (contact_array_1[i] and contact_array_2[i]) at time step: time_contact_array[i] and simulates
// SIR epidemics on these temporal network with T_value steps, contacts within window of size T_win_size are aggregated
// IMPORTANT: contact_arrays need to be sorted w.r.t. time_contact_array in time order !!!

	if (T_start > T_end){
		printf("ERROR : T_start %d in function: igraph_SIR_temporal_contact_network() > T_end %d \n", T_start, T_end);
		return;
	}

	igraph_vector_null(infected_nodes_history);
	igraph_dqueue_clear(p_infected_parameters->dq_infected_nodes);

	if ((p_infected_parameters->randomize_temporal_contacts == 1) && ( (sim_num == 0) || ((sim_num % 100) == 0) )){ //  use null after 100 simulations for speed
		//unsigned seed = std::chrono::system_clock::now().time_since_epoch().count() * getpid();
		if (p_infected_parameters->randomize_null_model_uniformly == 0){ // permuation null model
			randomize_temporal_contacts(p_infected_parameters, T_end, seed);
		}else{ // uniform null model
			randomize_temporal_contacts_uniformly(p_infected_parameters, T_end, seed);
		}
	}

	VECTOR(*infected_nodes_history)[p_infected_parameters->start_node] = 1; // here we status 1 for each node that got infected at any time

	vector<int> susceptible_state_in_time(p_infected_parameters->no_of_nodes,1); //here we write the whether node is susceptible in tmp_T step
	susceptible_state_in_time[p_infected_parameters->start_node] = 0;

	vector<int> infective_state_in_time(p_infected_parameters->no_of_nodes, 0); //here we write the whether node is infective in tmp_T step
	infective_state_in_time[p_infected_parameters->start_node] = 1;

	vector<int> node_recovery_probe_time(p_infected_parameters->no_of_nodes, 0); // hold info about last recovery probe time for lazy evaluation for recovery
	node_recovery_probe_time[p_infected_parameters->start_node] = T_start;

	int T_start_contact_idx = 0;
	while ( (p_infected_parameters->time_contact_array->at(T_start_contact_idx) < T_start) && (p_infected_parameters->time_contact_array->at(T_start_contact_idx) < T_end)){
		T_start_contact_idx++;
	}

	int T_last = T_start; // for verification of sorted list
	for(int i = T_start_contact_idx; i < p_infected_parameters->contact_array_1->size(); ++i){ //sweep over contacts or interactions not in time

		int tmp_T = p_infected_parameters->time_contact_array->at(i); // current time of contact
		if (T_last <= tmp_T){ // verification of time order

			if (tmp_T < T_end){ // proceed, simulation is not finished

				int contact_1 = p_infected_parameters->contact_array_1->at(i);
				int contact_2 = p_infected_parameters->contact_array_2->at(i);

				if ( infective_state_in_time[contact_1] ){ // recovery_step - lazy evaluation for contact 1
					int delta_t = tmp_T - node_recovery_probe_time.at(contact_1); // number of time steps that we did not probe contact_1 for recovery
					double q_tmp = 1 - ( pow((1-q),delta_t) ); // probability that nodes recovers after delta_t steps
					if (my_random() <= q_tmp){
						infective_state_in_time[contact_1] = 0;
					}
					node_recovery_probe_time.at(contact_1) = tmp_T; // we write time of last recovery probing for contact_1
				}

				if ( infective_state_in_time[contact_2] ){ // recovery_step - lazy evaluation for contact 2
					int delta_t = tmp_T - node_recovery_probe_time.at(contact_2);
					double q_tmp = 1 - ( pow((1-q),delta_t) ) ; // probability that nodes recovers after delta_t steps
					if (my_random() <= q_tmp){
						infective_state_in_time[contact_2] = 0;
					}
					node_recovery_probe_time.at(contact_2) = tmp_T;
				}

				if  ( infective_state_in_time[contact_1] && susceptible_state_in_time[contact_2] && (my_random() <= p)) { // infective step: contact_1 -> contact 2
					VECTOR(*infected_nodes_history)[contact_2] = 1; // second node becomes infected
					susceptible_state_in_time[contact_2] = 0;
					infective_state_in_time[contact_2] = 1;
					node_recovery_probe_time.at(contact_2) = tmp_T+1; // Recovery probing should be done only after this nodes tries to infect others
				}else if ( infective_state_in_time[contact_2] && susceptible_state_in_time[contact_1] && (my_random() <= p)){ // infective step: contact_1 <- contact 2
					VECTOR(*infected_nodes_history)[contact_1] = 1; // first node becomes infected
					susceptible_state_in_time[contact_1] = 0;
					infective_state_in_time[contact_1] = 1;
					node_recovery_probe_time.at(contact_1) = tmp_T+1;
				}

			}else{ // we have reached the end of simulation period
				break;
			}
			T_last = tmp_T;

		}else{ // contacts are not sorted in time !!!
			printf("\n ***!!! ERROR in igraph_SIR_temporal_contact_network(): Contacts are not sorted in time [time last: %d,time now %d] step:%d !!!*** \n", T_last, tmp_T,i);
			break;
		}

	}

	susceptible_state_in_time.clear();
	infective_state_in_time.clear();
	node_recovery_probe_time.clear();
}

void igraph_epidemic_weighted_temporal(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value) {

	igraph_vector_null(infected_nodes);
	igraph_dqueue_clear(p_infected_parameters->dq_infected_nodes);

    igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, p_infected_parameters->start_node);
    VECTOR(*infected_nodes)[p_infected_parameters->start_node] = 1;
	int dis_time = 1;
	int delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
	//printf("\n ------------------------discrete time step : %d -----------------", dis_time);

    while (igraph_dqueue_size(p_infected_parameters->dq_infected_nodes)) {
		if ( delta_nodes_pop == 0 ){
			dis_time++; // discrete epidemic time
			delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
			//printf("\n ------------------------discrete time step : %d -----------------", dis_time);
		}

		if ( dis_time <= T_value){
			long int current_node;
			current_node = (long int) igraph_dqueue_pop(p_infected_parameters->dq_infected_nodes);
			delta_nodes_pop--;
			//printf(" \n Current node: %d ", current_node);

			igraph_vector_t *neis;
			neis = igraph_adjlist_get(p_infected_parameters->al, current_node);
			igraph_real_t no_of_neigh;
			no_of_neigh = igraph_vector_size(neis);

			long int current_neigh;

			for (int i = 0; i < no_of_neigh; ++i) {
				current_neigh = (long int) VECTOR(*neis)[i];
				//printf(" neigbor %d ", current_neigh);

				// provjera da li je trenutni cvor vec podlozan
				if (VECTOR(*infected_nodes)[current_neigh] == 0) {
					double p_tmp = (double) igraph_spmatrix_e( p_infected_parameters->weight_mat, current_node, current_neigh);
					//printf(" weight %lf ", p_tmp);
					if (my_random() <= p_tmp) {
						igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, (igraph_real_t) current_neigh);
						VECTOR(*infected_nodes)[current_neigh] = 1;
						//printf(" \n Infected node: %d ", current_neigh);
					}
				}
			}

			if (my_random() > q) {
				igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, current_node);
			}
			// igraph_vector_destroy(neis);
		}else{
			break;
		}
    }
}

double my_random() {
    double scale = RAND_MAX + 1.;
    double base = rand() / scale;
    double fine = rand() / scale;
    return base + fine / scale;
}

void randomize_temporal_contacts(infected_structure * p_infected_parameters, int T_end, unsigned seed){
	// null model for temporal contacts, in each bin of size delta we shuffle uniformly contacts

	//printf("running randomization \n");
	int delta = p_infected_parameters->delta;
	if (delta == 0){
		return;
	}

	int T_start = p_infected_parameters->zero_time;
	//int T_end = T_start + T_value; // number of simulated steps

	vector<int> contact_rnd_idx;
	vector<int> contact_1_copy;
	vector<int> contact_2_copy;
	for(int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){ //make initial indexes by rank
		int tmp_T = p_infected_parameters->time_contact_array->at(i); // current time of contact
		if (tmp_T <= T_end){ // proceed, simulation is not finished
			contact_rnd_idx.push_back(i);
			contact_1_copy.push_back( p_infected_parameters->contact_array_1->at(i) ); // deep copy
			contact_2_copy.push_back( p_infected_parameters->contact_array_2->at(i) ); // deep copy
		}else{ // we have reached the end of simulation period
			break;
		}
	}

	/*
	printf("normal indexes : \n");
	for (int i = 0; i < 100; ++i){
		printf(" (%d,%d) ", contact_rnd_idx.at(i), p_infected_parameters->time_contact_array->at(i));
	}
	printf(" \n");
	 */


	vector<int>::iterator it_rnd_start = contact_rnd_idx.begin();
	vector<int>::iterator it_rnd_end;
	int index_rnd_start = 0;
	int index_rnd_end;
	for(int shuffle_T_start = T_start; shuffle_T_start < T_end; shuffle_T_start+=delta){

		index_rnd_end = index_rnd_start;
		it_rnd_end = it_rnd_start;
		while ( (p_infected_parameters->time_contact_array->at(index_rnd_end) < (shuffle_T_start+delta)) && (p_infected_parameters->time_contact_array->at(index_rnd_end) < (T_end)) ){ //find index_rnd_end
			index_rnd_end++;
			it_rnd_end++;
		}//now all contacts between index_rnd_start and index_rnd_end have time in [shuffle_T_start,shuffle_T_start+delta-1]
		it_rnd_end--;
		index_rnd_end--;

		shuffle(it_rnd_start, it_rnd_end, std::default_random_engine(seed)); //shuffle contact indexes between [shuffle_T_start,shuffle_T_start+delta-1]

		index_rnd_start = index_rnd_end+1;
		it_rnd_start = it_rnd_end+1;
	}

	/*
	printf("\n shuffle indexes with delta : %d \n", delta);
	for (int i = 0; i < 100; ++i){
		printf(" (%d,%d) ", contact_rnd_idx.at(i), p_infected_parameters->time_contact_array->at(i));
	}
	*/


	for(int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){ //copy shuffled array to p_infected structure
		int tmp_T = p_infected_parameters->time_contact_array->at(i); // current time of contact
		if (tmp_T < T_end){ // proceed, simulation is not finished
			p_infected_parameters->contact_array_1->at(i) = contact_1_copy[ contact_rnd_idx[i] ];
			p_infected_parameters->contact_array_2->at(i) = contact_2_copy[ contact_rnd_idx[i] ];
		}else{ // we have reached the end of simulation period
			break;
		}
	}



	contact_1_copy.clear();
	contact_2_copy.clear();
	contact_rnd_idx.clear();
}

void randomize_temporal_contacts_uniformly(infected_structure * p_infected_parameters, int T_end, unsigned seed){
	// null model for temporal contacts, in each bin of size delta size, for each contact we choose one day uniformly form delta bin
	// not so fast, we are n log n -> due tue sorting

	//printf("running uniform randomization \n");
	int delta = p_infected_parameters->delta;
	if (delta == 0){
		return;
	}

	int T_start = p_infected_parameters->zero_time;

	vector<pair<int,int> > contactRnd_time; //idx, time

	/*
	int num_print = 50;
	printf("normal indexes : \n");
	for (int i = 0; i < num_print; ++i){
		printf(" (%d,%d,%d) ", p_infected_parameters->contact_array_1->at(i), p_infected_parameters->contact_array_2->at(i), p_infected_parameters->time_contact_array->at(i));
	}
	printf(" \n");
	*/

	int index_rnd_start = 0;
	int index_rnd_end;
	for(int shuffle_T_start = T_start; shuffle_T_start < T_end; shuffle_T_start+=delta){

		index_rnd_end = index_rnd_start;
		while ( (p_infected_parameters->time_contact_array->at(index_rnd_end) < (shuffle_T_start+delta)) && (p_infected_parameters->time_contact_array->at(index_rnd_end) < (T_end)) ){ //find index_rnd_end
			int last_day = (shuffle_T_start+delta-1 > T_end) ? T_end : shuffle_T_start+delta-1;
			p_infected_parameters->time_contact_array->at(index_rnd_end) = getRandomDayFromPeriod(shuffle_T_start, last_day );
			contactRnd_time.push_back(make_pair(index_rnd_end, p_infected_parameters->time_contact_array->at(index_rnd_end))); //save index plus random time
			index_rnd_end++;
		}
		index_rnd_start = index_rnd_end;
	}

	//sort contacts ...
	sort_temporal_contact_by_time(p_infected_parameters, &contactRnd_time );

	/*
	printf("\n  indexes after sorting \n");
	for (int i = 0; i < num_print; ++i){
		printf(" (%d,%d) ", contactRnd_time.at(i).first, contactRnd_time.at(i).second);
	}
	printf("\n  contacts after sorting \n");
	for (int i = 0; i < num_print; ++i){
		printf(" (%d,%d,%d) ", p_infected_parameters->contact_array_1->at(i), p_infected_parameters->contact_array_2->at(i), p_infected_parameters->time_contact_array->at(i));
	}
	*/

	int tmp_T,last_T;
	tmp_T = p_infected_parameters->time_contact_array->at(0);
	last_T = tmp_T;
	for(int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){
		//printf("%d ", p_infected_parameters->time_contact_array->at(i));
		tmp_T = p_infected_parameters->time_contact_array->at(i);
		if (last_T <= tmp_T){
			continue;
		}else{
			printf("ERROR in sorting function step %d %d \n", last_T, tmp_T);
			break;
		}
		last_T = tmp_T;
	}

	contactRnd_time.clear();
}


struct sort_pred_temporal { //sort by time, second argument
    bool operator()(const std::pair<int,int> &left, const std::pair<int,int> &right) {
        return left.second < right.second;
    }
};

void sort_temporal_contact_by_time(infected_structure * p_infected_parameters, vector<pair<int,int>> * contactRnd_time){

	vector<int> contact_1_copy;
	vector<int> contact_2_copy;
	for(int i = 0; i < p_infected_parameters->contact_array_1->size(); ++i){ //copy
		contact_1_copy.push_back( p_infected_parameters->contact_array_1->at(i) ); // deep copy
		contact_2_copy.push_back( p_infected_parameters->contact_array_2->at(i) ); // deep copy
	}

	std::sort(contactRnd_time->begin(), contactRnd_time->end(), sort_pred_temporal());

	//rearrange by contactRnd_time->at(i).first indexes
	for(int i = 0; i < contactRnd_time->size(); ++i){ //copy shuffled array to p_infected structure
		p_infected_parameters->contact_array_1->at(i) = contact_1_copy[ contactRnd_time->at(i).first ];
		p_infected_parameters->contact_array_2->at(i) = contact_2_copy[ contactRnd_time->at(i).first ];
		p_infected_parameters->time_contact_array->at(i) = contactRnd_time->at(i).second;
	}

	contact_1_copy.clear();
	contact_2_copy.clear();
}



int getRandomDayFromPeriod(int start, int end){
	double rnd_day_double = my_random() * (end-start) + start;
	int day = (int) round(rnd_day_double);
	return day; //rand int from [start,end]
}


void igraph_epidemic_classic_temporal_prunning_identitiy(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value, igraph_vector_t * observed_realization, int * is_prunned) {
// this function generates normal SIR realization except it breaks in a case when we infect node that is not infected in observed realization !!
// we are prunning all realizations that are does not have suffient condition for identitiy -> this is used in unbiased estimators for scalability
// if at time t < T , (r_tmp(i) == 1) && (r_*(i) == 0) -> then I(r_tmp, t_*) at time T = 0 by definition

	clear_vector_idx(p_infected_parameters->q_infected_nodes_all, infected_nodes);
	igraph_dqueue_clear(p_infected_parameters->dq_infected_nodes);
	igraph_dqueue_clear(p_infected_parameters->q_infected_nodes_all);

    igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, p_infected_parameters->start_node);
    igraph_dqueue_push(p_infected_parameters->q_infected_nodes_all, p_infected_parameters->start_node);

    VECTOR(*infected_nodes)[p_infected_parameters->start_node] = 1;
	int dis_time = 1;
	int delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
	//printf("\n ------------------------discrete time step : %d -----------------", dis_time);
	long int num_inf_nodes = 1; //source

    while (igraph_dqueue_size(p_infected_parameters->dq_infected_nodes)) {
		if ( delta_nodes_pop == 0 ){
			dis_time++; // discrete epidemic time
			delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
			//printf("\n ------------------------discrete time step : %d -----------------", dis_time);
		}

		if ( dis_time <= T_value){
			long int current_node;
			current_node = (long int) igraph_dqueue_pop(p_infected_parameters->dq_infected_nodes);
			delta_nodes_pop--;
			//printf(" \n Current node: %d ", current_node);

			igraph_vector_t *neis;
			neis = igraph_adjlist_get(p_infected_parameters->al, current_node);
			igraph_real_t no_of_neigh;
			no_of_neigh = igraph_vector_size(neis);

			long int current_neigh;

			for (int i = 0; i < no_of_neigh; ++i) {
				current_neigh = (long int) VECTOR(*neis)[i];

				// provjera da li je trenutni cvor vec podlozan
				if (VECTOR(*infected_nodes)[current_neigh] == 0) {
					if (my_random() <= p) {
						igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, (igraph_real_t) current_neigh);
						igraph_dqueue_push(p_infected_parameters->q_infected_nodes_all, (igraph_real_t) current_neigh);
						VECTOR(*infected_nodes)[current_neigh] = 1;
						num_inf_nodes++;
						// indentity prunning
						if (VECTOR(*observed_realization)[current_neigh] == 0 ){
							*is_prunned = 1;
							return;
						}
					}
				}
			}

			if  (num_inf_nodes == p_infected_parameters->no_of_nodes){ //optimization line for small networks
				return; // do not wait for recovery if whole network is infected
			}

			if (my_random() > q) {
				igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, current_node);
			}
			// igraph_vector_destroy(neis);
		}else{
			break;
		}
    }
}

void clear_vector_idx(igraph_dqueue_t * queue_infected_nodes_all, igraph_vector_t * realization){
	 while (igraph_dqueue_size(queue_infected_nodes_all)) {
		 int current_node = (int) igraph_dqueue_pop(queue_infected_nodes_all);
		 VECTOR(*realization)[current_node] = 0;
	 }
}

void igraph_epidemic_classic_MC_pruning(infected_structure * p_infected_parameters, double p, double q, igraph_vector_t * infected_nodes, int T_value, igraph_vector_t * observed_realization, int * is_prunned, int error_threshold_nodes) {
// this function generates normal SIR realization except it breaks in a case when the error w.r.t observed realization is grater than the threshold

	clear_vector_idx(p_infected_parameters->q_infected_nodes_all, infected_nodes);
	igraph_dqueue_clear(p_infected_parameters->dq_infected_nodes);
	igraph_dqueue_clear(p_infected_parameters->q_infected_nodes_all);

    igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, p_infected_parameters->start_node);
    igraph_dqueue_push(p_infected_parameters->q_infected_nodes_all, p_infected_parameters->start_node);

    VECTOR(*infected_nodes)[p_infected_parameters->start_node] = 1;
	int dis_time = 1;
	int delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
	int error_term = 0;

    while (igraph_dqueue_size(p_infected_parameters->dq_infected_nodes)) {
		if ( delta_nodes_pop == 0 ){
			dis_time++; // discrete epidemic time
			delta_nodes_pop = igraph_dqueue_size(p_infected_parameters->dq_infected_nodes);
		}

		if ( dis_time <= T_value){
			long int current_node;
			current_node = (long int) igraph_dqueue_pop(p_infected_parameters->dq_infected_nodes);
			delta_nodes_pop--;

			igraph_vector_t *neis;
			neis = igraph_adjlist_get(p_infected_parameters->al, current_node);
			igraph_real_t no_of_neigh;
			no_of_neigh = igraph_vector_size(neis);

			long int current_neigh;

			for (int i = 0; i < no_of_neigh; ++i) {
				current_neigh = (long int) VECTOR(*neis)[i];

				// make better pipelining code ! optimization
				// provjera da li je trenutni cvor vec podlozan
				if (VECTOR(*infected_nodes)[current_neigh] == 0) {
					if (my_random() <= p) {
						igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, (igraph_real_t) current_neigh);
						igraph_dqueue_push(p_infected_parameters->q_infected_nodes_all, (igraph_real_t) current_neigh);
						VECTOR(*infected_nodes)[current_neigh] = 1;
						// indentity prunning
						if (VECTOR(*observed_realization)[current_neigh] == 0 ){
							error_term++;
							if (error_term > error_threshold_nodes){
								*is_prunned = 1;
								return;
							}
						}
					}
				}
			}

			if (my_random() > q) {
				igraph_dqueue_push(p_infected_parameters->dq_infected_nodes, current_node);
			}
		}else{
			break;
		}
    }
}


